/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.tables;

import filenet.vw.api.VWFaultDefinition;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWInvokeInstruction;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWPartnerLinkDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.VWWebServiceUtils;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import filenet.ws.api.WSFault;
import filenet.ws.api.WSOperation;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.table.AbstractTableModel;

public class VWSpecificFaultsTableModel
extends AbstractTableModel {
    private static final int COL_COUNT = 3;
    public static final int COL_NAME = 0;
    public static final int COL_FIELD = 1;
    public static final int COL_MAP = 2;
    private Vector m_rowData = null;
    private JComboBox m_faultNameComboBox = null;
    private JComboBox m_xmlFieldComboBox = null;
    private JComboBox m_submapComboBox = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWInvokeInstruction m_instructionDef = null;
    private WSOperation m_wsOperation = null;
    private String m_tempField = VWResource.s_noneItemStr;
    private String m_tempMap = VWResource.s_noneItemStr;

    public VWSpecificFaultsTableModel(VWAuthPropertyData authPropertyData) {
        this.m_authPropertyData = authPropertyData;
        this.m_rowData = new Vector();
    }

    public JComboBox getFaultComboBox() {
        DefaultComboBoxModel<String> cbModel = new DefaultComboBoxModel<String>();
        try {
            Object[] wsFaults;
            VWWebServiceUtils wsUtils;
            VWPartnerLinkDefinition partnerLinkDef;
            String partnerLinkName;
            String operationName;
            if (this.m_wsOperation == null && this.m_instructionDef != null && (operationName = this.m_instructionDef.getOperationName()) != null && operationName.length() > 0 && (partnerLinkName = this.m_instructionDef.getPartnerLinkName()) != null && partnerLinkName.length() > 0 && (partnerLinkDef = this.m_authPropertyData.getPartnerLink(partnerLinkName)) != null && (wsUtils = this.m_authPropertyData.getWebServiceUtils()) != null) {
                this.m_wsOperation = wsUtils.getOperationFromPartnerLink(partnerLinkDef, operationName);
            }
            if (this.m_wsOperation != null && (wsFaults = this.m_wsOperation.getFaults()) != null && wsFaults.length > 0) {
                VWQubbleSort.sort(wsFaults);
                for (int i = 0; i < wsFaults.length; ++i) {
                    cbModel.addElement(((WSFault)wsFaults[i]).getName());
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        if (this.m_faultNameComboBox != null) {
            this.m_faultNameComboBox.setModel(cbModel);
        } else {
            this.m_faultNameComboBox = new JComboBox(cbModel);
        }
        return this.m_faultNameComboBox;
    }

    public JComboBox getXMLFieldComboBox() {
        DefaultComboBoxModel<Object> cbModel = new DefaultComboBoxModel<Object>();
        try {
            cbModel.addElement(VWResource.s_noneItemStr);
            VWFieldDefinition[] fieldDefs = this.m_authPropertyData.getFields();
            if (fieldDefs != null && fieldDefs.length > 0) {
                Vector<String> fieldNamesVec = new Vector<String>();
                for (int i = 0; i < fieldDefs.length; ++i) {
                    VWFieldDefinition fieldDef = fieldDefs[i];
                    if (fieldDef.getFieldType() != 128 && fieldDef.getFieldType() != 2) continue;
                    fieldNamesVec.addElement(fieldDef.getName());
                }
                if (fieldNamesVec.size() > 0) {
                    Object[] fieldNames = new String[fieldNamesVec.size()];
                    fieldNamesVec.copyInto(fieldNames);
                    VWQubbleSort.sort(fieldNames);
                    for (int i = 0; i < fieldNames.length; ++i) {
                        cbModel.addElement(fieldNames[i]);
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        if (this.m_xmlFieldComboBox != null) {
            this.m_xmlFieldComboBox.setModel(cbModel);
        } else {
            this.m_xmlFieldComboBox = new JComboBox(cbModel);
            this.m_xmlFieldComboBox.setEditable(true);
        }
        return this.m_xmlFieldComboBox;
    }

    public JComboBox getMapComboBox() {
        DefaultComboBoxModel<Object> cbModel = new DefaultComboBoxModel<Object>();
        try {
            cbModel.addElement(VWResource.s_noneItemStr);
            if (this.m_authPropertyData != null) {
                cbModel.addElement("Workflow");
                cbModel.addElement("Malfunction");
                cbModel.addElement("Terminate");
                Object[] mapNames = null;
                VWMapDefinition[] mapDefs = this.m_authPropertyData.getMapCache().getMapDefinitions();
                if (mapDefs != null && mapDefs.length > 0) {
                    Vector<String> mapNamesVec = new Vector<String>();
                    for (int i = 0; i < mapDefs.length; ++i) {
                        String mapName = mapDefs[i].getName();
                        if (VWStringUtils.compare(mapName, "Workflow") == 0 || VWStringUtils.compare(mapName, "Malfunction") == 0 || VWStringUtils.compare(mapName, "Terminate") == 0) continue;
                        mapNamesVec.addElement(mapName);
                    }
                    mapNames = new String[mapNamesVec.size()];
                    mapNamesVec.copyInto(mapNames);
                }
                if (mapNames != null && mapNames.length > 0) {
                    VWQubbleSort.sort(mapNames);
                    for (int i = 0; i < mapNames.length; ++i) {
                        void mapName = mapNames[i];
                        if (VWStringUtils.compareIgnoreCase((String)mapName, "") == 0) continue;
                        cbModel.addElement(mapName);
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        if (this.m_submapComboBox != null) {
            this.m_submapComboBox.setModel(cbModel);
        } else {
            this.m_submapComboBox = new JComboBox(cbModel);
        }
        return this.m_submapComboBox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinitialize(VWInvokeInstruction instructionDef, WSOperation wsOperation) {
        this.m_instructionDef = instructionDef;
        this.m_wsOperation = wsOperation;
        try {
            VWFaultDefinition[] vwFaultDefs;
            this.getFaultComboBox();
            this.getMapComboBox();
            this.m_rowData.removeAllElements();
            if (this.m_instructionDef != null && (vwFaultDefs = this.m_instructionDef.getFaults()) != null && vwFaultDefs.length > 0) {
                for (int i = 0; i < vwFaultDefs.length; ++i) {
                    this.m_rowData.addElement(vwFaultDefs[i]);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            this.fireTableDataChanged();
        }
    }

    public void up(int rowIndex) {
        try {
            if (rowIndex != 0) {
                Object currentObj = this.m_rowData.elementAt(rowIndex);
                Object previousObj = this.m_rowData.elementAt(rowIndex - 1);
                this.m_rowData.setElementAt(currentObj, rowIndex - 1);
                this.m_rowData.setElementAt(previousObj, rowIndex);
                this.updateFaults();
                this.fireTableDataChanged();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void down(int rowIndex) {
        try {
            if (rowIndex < this.getRowCount() - 2) {
                Object currentObj = this.m_rowData.elementAt(rowIndex);
                Object previousObj = this.m_rowData.elementAt(rowIndex + 1);
                this.m_rowData.setElementAt(currentObj, rowIndex + 1);
                this.m_rowData.setElementAt(previousObj, rowIndex);
                this.updateFaults();
                this.fireTableDataChanged();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void delete(int rowIndex) {
        try {
            if (rowIndex >= 0 && rowIndex < this.m_rowData.size()) {
                this.m_rowData.removeElementAt(rowIndex);
                this.updateFaults();
                this.fireTableRowsDeleted(rowIndex, rowIndex);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Class getColumnClass(int nColumnIndex) {
        Class<String> resultClass = null;
        switch (nColumnIndex) {
            case 0: 
            case 1: 
            case 2: {
                resultClass = String.class;
            }
        }
        return resultClass;
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int nColumnIndex) {
        String resultString = null;
        switch (nColumnIndex) {
            case 0: {
                resultString = VWResource.s_nameStr;
                break;
            }
            case 1: {
                resultString = VWResource.s_xmlDataField;
                break;
            }
            case 2: {
                resultString = VWResource.s_submap;
            }
        }
        return resultString;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size() + 1;
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        if (nRowIndex >= 0 && nColumnIndex >= 0) {
            VWFaultDefinition vwFaultDef = this.getFaultDefinition(nRowIndex);
            switch (nColumnIndex) {
                case 0: {
                    if (vwFaultDef != null) {
                        return vwFaultDef.getName();
                    }
                    return null;
                }
                case 1: {
                    if (vwFaultDef != null) {
                        String xmlField = vwFaultDef.getFaultMessage();
                        if (xmlField != null && xmlField.length() > 0) {
                            return xmlField;
                        }
                        return VWResource.s_noneItemStr;
                    }
                    return this.m_tempField;
                }
                case 2: {
                    if (vwFaultDef != null) {
                        String mapName = vwFaultDef.getFaultMapName();
                        if (mapName != null && mapName.length() > 0) {
                            return mapName;
                        }
                        return VWResource.s_noneItemStr;
                    }
                    return this.m_tempMap;
                }
            }
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        return true;
    }

    public void setValueAt(Object value, int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                this.onNameUpdate(nRowIndex, value);
                break;
            }
            case 1: {
                this.onFieldUpdate(nRowIndex, value);
                break;
            }
            case 2: {
                this.onMapUpdate(nRowIndex, value);
            }
        }
    }

    private void onNameUpdate(int nRowIndex, Object aValue) {
        block8: {
            try {
                if (aValue != null && aValue instanceof String) {
                    String name = (String)aValue;
                    VWFaultDefinition fault = this.getFaultDefinition(nRowIndex);
                    if (fault != null) {
                        fault.setName(name);
                        this.updateFaults();
                    } else if (VWStringUtils.compareIgnoreCase(name, VWResource.s_noneItemStr) != 0) {
                        String fieldName = null;
                        if (VWStringUtils.compare(this.m_tempField, VWResource.s_noneItemStr) != 0) {
                            fieldName = this.m_tempField;
                        }
                        String mapName = null;
                        if (VWStringUtils.compare(this.m_tempMap, VWResource.s_noneItemStr) != 0) {
                            mapName = this.m_tempMap;
                        }
                        fault = this.m_instructionDef.createFault(name, fieldName, mapName);
                        this.m_rowData.addElement(fault);
                        this.updateFaults();
                        this.fireTableRowsInserted(this.m_rowData.size(), this.m_rowData.size() + 1);
                        this.m_tempField = VWResource.s_noneItemStr;
                        this.m_tempMap = VWResource.s_noneItemStr;
                    }
                    this.fireTableCellUpdated(nRowIndex, 0);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block8;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    private void onFieldUpdate(int nRowIndex, Object aValue) {
        try {
            if (aValue != null && aValue instanceof String) {
                String fieldName = (String)aValue;
                VWFaultDefinition fault = this.getFaultDefinition(nRowIndex);
                if (fault != null) {
                    fault.setFaultMessage(fieldName);
                    this.updateFaults();
                } else {
                    this.m_tempField = fieldName;
                }
                this.fireTableCellUpdated(nRowIndex, 1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onMapUpdate(int nRowIndex, Object aValue) {
        try {
            if (aValue != null && aValue instanceof String) {
                String map = (String)aValue;
                VWFaultDefinition fault = this.getFaultDefinition(nRowIndex);
                if (fault != null) {
                    if (VWStringUtils.compareIgnoreCase(map, VWResource.s_noneItemStr) != 0) {
                        fault.setFaultMapName(map);
                    } else {
                        fault.setFaultMapName(null);
                    }
                    this.updateFaults();
                } else {
                    this.m_tempMap = map;
                }
                this.fireTableCellUpdated(nRowIndex, 2);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private VWFaultDefinition getFaultDefinition(int nRowIndex) {
        Object obj;
        VWFaultDefinition faultDef = null;
        if (this.m_rowData != null && nRowIndex < this.m_rowData.size() && (obj = this.m_rowData.elementAt(nRowIndex)) != null) {
            faultDef = (VWFaultDefinition)obj;
        }
        return faultDef;
    }

    private void updateFaults() {
        try {
            Object[] faults = null;
            if (this.m_rowData.size() > 0) {
                faults = new VWFaultDefinition[this.m_rowData.size()];
                this.m_rowData.copyInto(faults);
            }
            this.m_instructionDef.setFaults((VWFaultDefinition[])faults);
            this.m_authPropertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

